/********************************************************************************
             MELISSA DATA ADDRESS OBJECT 'C' EXAMPLE
 If you should have any comments, suggestions or improvements to these samples,
 we welcome you to contact us at SampleCode@melissadata.com also please visit our
 developers bulletin board at forum.melissadata.com.
********************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "mdAddr.h"
#define DATAPATH "C:\\Program Files\\Melissa DATA\\DQT\\Data"

mdAddr hAddrLib;

int main(int argc,char **argv)
{
  char company[50],address[50], address2[50], city[30], state[15], zip[10], urbanization[25], lastname[20], *p;
    char *resultsString;
  hAddrLib = mdAddrCreate();

    /********************** LICENSE STRINGS ***********************
    *     To unlock the full functionality of Address Object,     *
    * please call a sales representative at 1-800-MELISSA ext. 3  *
    *         (1-800-635-4772 x3) for a license string.           *
    *     Without a valid license string, the demo will process   *
    *                only code Nevada Zip Codes.                  *
    * SetLicenseString also checks for a valid license in the     * 
    * MDADDR_LICENSE environment variable. This allows you to     *
    * modify the license without recompilation.                   *
    **************************************************************/
  mdAddrSetLicenseString(hAddrLib, "DEMO");
  

    /*********************** DATA FILE PATH  ***********************
    * File location path is set to the default Data File location. *
    * Change this value if you installed the data files to a       *
    * different folder.                                            *
    * The Data Files Directory must contain the following files:   *
    *  mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str          *
    ***************************************************************/
  mdAddrSetPathToUSFiles(hAddrLib,DATAPATH);
  //mdAddrSetPathToDPVDataFiles(hAddrLib,DATAPATH);
  //mdAddrSetPathToLACSLinkDataFiles(hAddrLib,DATAPATH);
  //mdAddrSetPathToSuiteLinkDataFiles(hAddrLib,DATAPATH);
  //mdAddrSetPathToRBDIFiles(hAddrLib,DATAPATH);                //Delivery Indicator Add-on (Residence or Business) 
  //mdAddrSetPathToCanadaFiles(hAddrLib,DATAPATH);              //Canadian Address Validation Add-on
  //mdAddrSetPathToSuiteFinderDataFiles(hAddrLib,DATAPATH);     //AddressPlus Add-on (appends residential suites)

  //To Print a CASS form
  //mdAddrSetCASSEnable(hAddrLib,1);

  //Initialize
  mdAddrInitializeDataFiles(hAddrLib);

  //Print Data File Information
  printf("==========================================\n");
  printf("                   Build: %s \n", mdAddrGetBuildNumber(hAddrLib));
  printf("           Database Date: %s \n", mdAddrGetDatabaseDate(hAddrLib));
  printf("         Expiration Date: %s \n", mdAddrGetExpirationDate(hAddrLib));
  printf("       Initialize Errors: %s \n", mdAddrGetInitializeErrorString(hAddrLib));
  printf("==========================================\n");

  // clear any properties from a previous call
  mdAddrClearProperties(hAddrLib);

  printf("   Enter Company: ");
  fgets(company, sizeof company, stdin);
  if((p = strchr(company, '\n')) != NULL)
    *p = '\0';
  mdAddrSetCompany(hAddrLib,company);

  printf("   Enter Address: ");
  fgets(address, sizeof address, stdin);
  if((p = strchr(address, '\n')) != NULL)
    *p = '\0';
  mdAddrSetAddress(hAddrLib, address);

  printf("  Enter Address2: ");
  fgets(address2, sizeof address2, stdin);
  if((p = strchr(address2, '\n')) != NULL)
    *p = '\0';
  mdAddrSetAddress2(hAddrLib,address2);

  printf("      Enter City: ");
  fgets(city, sizeof city, stdin);
  if((p = strchr(city, '\n')) != NULL)
    *p = '\0';
  mdAddrSetCity(hAddrLib, city);

  printf("     Enter State: ");
  fgets(state, sizeof state, stdin);
  if((p = strchr(state, '\n')) != NULL)
    *p = '\0';
  mdAddrSetState(hAddrLib, state);

  printf("       Enter Zip: ");
  fgets(zip, sizeof zip, stdin);
  if((p = strchr(zip, '\n')) != NULL)
    *p = '\0';
  mdAddrSetZip(hAddrLib, zip);

  printf("Enter Urbanization: ");
  fgets(urbanization, sizeof urbanization, stdin);
  if((p = strchr(urbanization, '\n')) != NULL)
    *p = '\0';
  mdAddrSetUrbanization(hAddrLib, urbanization);

  printf("Enter Last Name of Resident:");
    fgets(lastname, sizeof lastname, stdin);
    if((p = strchr(lastname, '\n')) != NULL)
    *p = '\0';
  mdAddrSetLastName(hAddrLib, lastname);

  printf("==========================================\n");
  //Verify Address
  mdAddrVerifyAddress(hAddrLib);

  printf("OUTPUT RESULTS...\n");
  printf("           Company: %s \n", mdAddrGetCompany(hAddrLib));
  printf("           Address: %s \n", mdAddrGetAddress(hAddrLib));
  printf("          Address2: %s \n", mdAddrGetAddress2(hAddrLib));
  printf("             Suite: %s \n", mdAddrGetSuite(hAddrLib));
  printf("              City: %s \n", mdAddrGetCity(hAddrLib));
  printf("             State: %s \n", mdAddrGetState(hAddrLib));
  printf("               Zip: %s \n", mdAddrGetZip(hAddrLib));
  printf("             Plus4: %s \n", mdAddrGetPlus4(hAddrLib));
  printf("\n");

  // results are returned as delimited string, so we parse the descriptions here
  printf("Results Codes...\n");
  resultsString = mdAddrGetResults(hAddrLib);
  if ((strstr(resultsString,"AS01")!=0) || (strstr(resultsString,"AS02")!=0) || (strstr(resultsString,"AS03")!=0))
  {     
      // address was verified
      if (strstr(resultsString,"AS01")!=0)
        printf(" AS01: Full Address Matched to Postal Database and is deliverable\n");
      if (strstr(resultsString,"AS02")!=0)
        printf(" AS02: Address matched to USPS database but a suite was missing or invalid\n");
	  if (strstr(resultsString,"AS03")!=0)
		printf("AS03: Valid Physical Address, not Serviced by the USPS \n");
  } 
    
  //Display additional level of verification/comments
 
  if (strstr(resultsString,"AS09")!=0)
        printf(" AS09: Foreign Postal Code Detected \n");
    if (strstr(resultsString,"AS10")!=0)
        printf(" AS10: Address Matched to CMRA\n");
    if (strstr(resultsString,"AS13")!=0)
        printf(" AS13: Address has been Updated by LACSLink \n");
    if (strstr(resultsString,"AS14")!=0)
        printf(" AS14: Suite Appended by SuiteLink \n");
    if (strstr(resultsString,"AS15")!=0)
        printf(" AS15: Suite Appended by SuiteFinder \n");
    if (strstr(resultsString,"AS16")!=0)
        printf(" AS16: Address is vacant.\n");
    if (strstr(resultsString,"AS17")!=0)
        printf(" AS17: Alternate delivery.\n");
    if (strstr(resultsString,"AS18")!=0)
        printf(" AS18: DPV processing was terminated artificially created adresses detected.\n");
    if (strstr(resultsString,"AS20")!=0)
        printf(" AS20: Address Deliverable by USPS only \n");  
    if (strstr(resultsString,"AS21")!=0)
        printf(" AS21: Alternate Address Suggestion Found \n");
    if (strstr(resultsString,"AS22")!=0)
        printf(" AS22: No Alternate Address Suggestion Found\n");
    if (strstr(resultsString,"AS23")!=0)
        printf(" AS23: Extraneous information found \n");        
        
    
   if (strstr(resultsString,"AE")!=0)
   {   
      // there was an error in verifying the address
      printf(" Address could not be verified \n");
      if (strstr(resultsString,"AE01")!=0)
        printf(" AE01: Zip Code Error \n");
      if (strstr(resultsString,"AE02")!=0)
        printf(" AE02: Unknown Street Error \n");
      if (strstr(resultsString,"AE03")!=0)
        printf(" AE03: Component Mismatch Error \n");
      if (strstr(resultsString,"AE04")!=0)
        printf(" AE04: Non-Deliverable Address Error \n");
      if (strstr(resultsString,"AE05")!=0)
        printf(" AE05: Multiple Match Error \n");
      if (strstr(resultsString,"AE06")!=0)
        printf(" AE06: Early Warning System Error \n");
      if (strstr(resultsString,"AE07")!=0)
        printf(" AE07: Missing Minimum Address Input \n");
      if (strstr(resultsString,"AE08")!=0)
        printf(" AE08: Suite Range Invalid Error\n");
      if (strstr(resultsString,"AE09")!=0)
        printf(" AE09: Suite Range Missing Error \n");
      if (strstr(resultsString,"AE10")!=0)
        printf(" AE10: Primary Range Invalid Error \n");
      if (strstr(resultsString,"AE11")!=0)
        printf(" AE11: Primary Range Missing Error \n");
      if (strstr(resultsString,"AE12")!=0)
        printf(" AE12: PO, HC, or RR Box Number Invalid \n");
      if (strstr(resultsString,"AE13")!=0)
        printf(" AE13: PO, HC, or RR Box Number Missing \n");
      if (strstr(resultsString,"AE14")!=0)
        printf(" AE14: CMRA Secondary Missing Error\n");

      // program can not attempt address lookup
      if (strstr(resultsString,"AE15")!=0)
        printf(" AE15: Demo Mode limitation, valid license required \n");
      if (strstr(resultsString,"AE16")!=0)
        printf(" AE16: Expired Database, Please Update\n");

      if (strstr(resultsString,"AE17")!=0)
        printf(" AE17: Unnecessary Suite Error \n");
      if (strstr(resultsString,"AE19")!=0)
        printf(" AE19: Max time for FindSuggestion exceeded\n");       
      if (strstr(resultsString,"AE20")!=0)
        printf(" AE20: FindSuggestion cannot be used\n"); 
    }
    
  if (strstr(resultsString,"AC01")!=0)
        printf(" AC01: ZIP Code Change\n"); 
  if (strstr(resultsString,"AC02")!=0)  
        printf(" AC02: State Change\n"); 
  if (strstr(resultsString,"AC03")!=0)
        printf(" AC03: City Change\n"); 
  if (strstr(resultsString,"AC04")!=0)
        printf(" AC04: Base/Alternate Change\n"); 
  if (strstr(resultsString,"AC05")!=0)
        printf(" AC05: Alias Name Change\n"); 
  if (strstr(resultsString,"AC06")!=0)
        printf(" AC06: Address1/Address2 Swap\n"); 
  if (strstr(resultsString,"AC07")!=0)
        printf(" AC07: Address1/Company Swap\n"); 
  if (strstr(resultsString,"AC08")!=0)
        printf(" AC08: Plus4 Change\n"); 
  if (strstr(resultsString,"AC09")!=0)
        printf(" AC09: Urbanization Change\n"); 
  if (strstr(resultsString,"AC10")!=0)
        printf(" AC10: Street Name Change\n"); 
  if (strstr(resultsString,"AC11")!=0)
        printf(" AC11: Street Suffix Change\n");
  if (strstr(resultsString,"AC12")!=0)
        printf(" AC12: Street Directional Change\n"); 
  if (strstr(resultsString,"AC13")!=0)
        printf(" AC13: Suite Name Change\n"); 

    printf("\n");
    printf("            Carrier Route: %s \n", mdAddrGetCarrierRoute(hAddrLib));
    printf("           Delivery Point: %s \n", mdAddrGetDeliveryPointCode(hAddrLib));
    printf("                     DPCD: %s \n", mdAddrGetDeliveryPointCheckDigit(hAddrLib));
    printf("             DPVFootnotes: %s \n", mdAddrGetDPVFootnotes(hAddrLib));
    printf("\n");
    printf("          AddressTypeCode: %s \n", mdAddrGetAddressTypeCode(hAddrLib));
    printf("        AddressTypeString: %s \n", mdAddrGetAddressTypeString(hAddrLib));
    printf("         CityAbbreviation: %s \n", mdAddrGetCityAbbreviation(hAddrLib));
    printf("               CountyFips: %s \n", mdAddrGetCountyFips(hAddrLib));
    printf("               CountyName: %s \n", mdAddrGetCountyName(hAddrLib));
    printf("              CountryCode: %s \n", mdAddrGetCountryCode(hAddrLib));
    printf("    CongressionalDistrict: %s \n", mdAddrGetCongressionalDistrict(hAddrLib));
    printf("                 TimeZone: %s \n", mdAddrGetTimeZone(hAddrLib));
    printf("             TimeZoneCode: %s \n", mdAddrGetTimeZoneCode(hAddrLib));
    printf("            Urbanization : %s \n", mdAddrGetUrbanization(hAddrLib));
    printf("                  ZipType: %s \n", mdAddrGetZipType(hAddrLib));
    printf("\n");
    printf("       ParsedAddressRange: %s \n", mdAddrGetParsedAddressRange(hAddrLib));
    printf("       ParsedPreDirection: %s \n", mdAddrGetParsedPreDirection(hAddrLib));
    printf("         ParsedStreetName: %s \n", mdAddrGetParsedStreetName(hAddrLib));
    printf("             ParsedSuffix: %s \n", mdAddrGetParsedSuffix(hAddrLib));
    printf("      ParsedPostDirection: %s \n", mdAddrGetParsedPostDirection(hAddrLib));
    printf("          ParsedSuiteName: %s \n", mdAddrGetParsedSuiteName(hAddrLib));
    printf("         ParsedSuiteRange: %s \n", mdAddrGetParsedSuiteRange(hAddrLib));
    printf(" ParsedPrivateMailboxName: %s \n", mdAddrGetParsedPrivateMailboxName(hAddrLib));
    printf("  ParsedPrivMailboxNumber: %s \n", mdAddrGetParsedPrivateMailboxNumber(hAddrLib));
    printf("            ParsedGarbage: %s \n", mdAddrGetParsedGarbage(hAddrLib));
    printf("\n");
    printf("                      MSA: %s \n", mdAddrGetMsa(hAddrLib));
    printf("                     PMSA: %s \n", mdAddrGetPmsa(hAddrLib));
    printf("                     CMRA: %s \n", mdAddrGetCMRA(hAddrLib));
    printf("          Private MailBox: %s \n", mdAddrGetPrivateMailbox(hAddrLib));
    printf("\n");
    printf("                ELotOrder: %s \n", mdAddrGetELotOrder(hAddrLib));
    printf("               ELotNumber: %s \n", mdAddrGetELotNumber(hAddrLib));
    printf("                     LACS: %s \n", mdAddrGetLACS(hAddrLib));
    printf("       LACSLink Indicator: %s \n", mdAddrGetLACSLinkIndicator(hAddrLib));
    printf("       LACSLinkReturnCode: %s \n", mdAddrGetLACSLinkReturnCode(hAddrLib));
    printf("      SuiteLinkReturnCode: %s \n", mdAddrGetSuiteLinkReturnCode(hAddrLib));
    printf("                      EWS: %s \n", mdAddrGetEWSFlag(hAddrLib));
    printf("                     RBDI: %s \n", mdAddrGetRBDI(hAddrLib));

  mdAddrDestroy(hAddrLib);

}
